//
//  WDDisk.h
//  WDUtility
//
//  Created by bob hahn on 7/26/11.
//  Copyright 2011 Western Digital Technologies, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <IOKit/storage/ata/ATASMARTLib.h>

@interface WDDiskEraseProgress : NSObject {
	bool	eraseInProgress;
	double	percentageComplete;
}

@property (nonatomic, readwrite, assign)	bool	eraseInProgress;
@property (nonatomic, readwrite, assign)	double	percentageComplete;

@end

@interface WDDisk : NSObject {
	NSString *		mPortName;
	io_service_t	mIOAHCIDevice;
	NSString *		mSerialNumber;
	NSString *		mModel;
	NSString *		mDiskBSDName;
	UInt8			mSlotNumber;
	UInt64			mDiskSize;
	Boolean			mRAIDMember;
	NSString *		mRAIDBSDName;
	UInt64			mRAIDSize;
	NSString *		mRAIDLevel;
	NSString *		mRAIDSetName;
	NSString *		mRAIDStatus;
	NSString *		mRAIDFormat;
	NSString *		mRAIDMemberStatus;
	NSString *		mRAIDMemberUUID;
	NSNumber *		mRAIDRebuildProgress;
	NSString *		mRAIDSetUUID;
	NSArray *		mRAIDSetMembers;
	Boolean			mTestInProgress;
	Boolean			mEraseInProgress;
	double			mEraseProgressPercentage;
	UInt64			mTunnelEndpointGUID;
	NSMutableArray *mVolumes;
	
@private
	io_service_t				mSmartLibPluginNub;
	IOCFPlugInInterface **		mPlugInIterface;
	IOATASMARTInterface **		mSMARTTaskDevInterface;
	NSLock						*mWDDiskLock;
	
	BOOL						mdeviceOpen;
}

@property (readwrite,copy) NSString *		mPortName;
@property (readwrite,assign) io_service_t	mIOAHCIDevice;
@property (readwrite,copy) NSString *		mSerialNumber;
@property (readwrite,copy) NSString *		mModel;
@property (readwrite,copy) NSString *		mDiskBSDName;
@property (readwrite,assign) UInt8			mSlotNumber;
@property (readwrite,assign) UInt64         mDiskSize;
@property (readwrite,assign) Boolean		mRAIDMember;
@property (readwrite,copy) NSString *		mRAIDBSDName;
@property (readwrite,assign) UInt64			mRAIDSize;
@property (readwrite,copy) NSString *		mRAIDLevel;
@property (readwrite,copy) NSString *		mRAIDSetName;
@property (readwrite,copy) NSString *		mRAIDStatus;
@property (readwrite,copy) NSString *		mRAIDFormat;
@property (readwrite,copy) NSString *		mRAIDMemberStatus;
@property (readwrite,copy) NSString *		mRAIDMemberUUID;
@property (readwrite,copy) NSNumber *		mRAIDRebuildProgress;
@property (readwrite,copy) NSString *		mRAIDSetUUID;
@property (readwrite,copy) NSArray *		mRAIDSetMembers;
@property (readwrite,assign) UInt64			mTunnelEndpointGUID;
@property (readwrite,assign) Boolean		mTestInProgress;
@property (readwrite,assign) Boolean		mEraseInProgress;
@property (readwrite,assign) double			mEraseProgressPercentage;
@property (readwrite,copy) NSMutableArray *	mVolumes;

- (id) initWithServiceObject: (io_service_t) diskServiceObject;

- (int) getSmartData:(NSMutableDictionary **)smartDataDict error:(NSMutableDictionary **)errorDict; 
- (int) getRawSmartData:(ATASMARTData *)smartDataBuffer;
- (int) getSmartStatus:(NSMutableDictionary **)smartStatusDict error:(NSMutableDictionary **)errorDict;
- (int) getSmartReturnStatus: (Boolean *)exceededCondition;

- (void)unmount;
- (void) writeZerosToDisk: (WDDiskEraseProgress *) progressBlock;

-(IOReturn) startShortTest;
-(IOReturn) startExtendedTest;
-(IOReturn) abortTest;

-(IOReturn) openSMARTInterface;
-(IOReturn) closeSMARTInterface;
-(IOReturn) getDiagnosticStatus:(NSMutableDictionary **)diagStatusData error:(NSMutableDictionary **)errorDict;

@end
